% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counter.R
\name{counter_state}
\alias{counter_state}
\alias{counter_reset}
\alias{counter_names}
\alias{counter_tags}
\alias{counter_get}
\title{whereami counter}
\usage{
counter_state(item = NULL, tag = NULL)

counter_reset(item = NULL, tag = NULL)

counter_names()

counter_tags()

counter_get()
}
\arguments{
\item{item}{character, name of the counter to access, Default: NULL}

\item{tag}{character, tag of the counter to acces, if it was set at initial whereami call.
This can be used instead of the item name, Default: NULL}
}
\description{
Interact with internal whereami counter
}
\details{
\code{counter_names()} returns names of the active stored counters.

\code{counter_state()} returns current hit count for item, if NULL then all counters
are returned.

\code{counter_reset()} will remove counter of item, if item is NULL then all counters
are reset.

\code{counter_get()} returns a table with all the counters. These can then
be plotted with the with the plot method.

A json log of the counter is written to file.path(tempdir(),'whereami.json') by default
The path can be set using \link[=set_whereami_log]{set_whereami_log}
}
\examples{

if(interactive()){

txt <- "
whereami::cat_where(whereami::whereami(tag = 'tag1'))
"

tf <- tempfile(fileext = '.R')

cat(txt,file = tf)

source(tf)

counter_state()

counter_state(tag = 'tag1')

counter_names()

counter_tags()

counters <- counter_get()

counters

plot(counter_get())

# read the json log
jsonlite::read_json(
file.path(tempdir(),'whereami.json'),
simplifyVector = TRUE)

# clear all counters
counter_reset()

#verify that there are no active counters
counter_state()

# cleanup
unlink(tf)

}

}
\seealso{
Other counter: 
\code{\link{set_whereami_log}()}
}
\author{
Jonathan Sidi
}
\concept{counter}
