% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sources.R
\name{expand_trade_sources}
\alias{expand_trade_sources}
\title{Trade data sources}
\usage{
expand_trade_sources(trade_sources)
}
\arguments{
\item{trade_sources}{A tibble dataframe where each row contains the
year range.}
}
\value{
A tibble dataframe where each row corresponds to a single year for
a given source.
}
\description{
Create a new dataframe where each row has a year range into one where each
row is a single year, effectively 'expanding' the whole year range.
}
\examples{
trade_sources <- tibble::tibble(
  Name = c("a", "b", "c"),
  Trade = c("t1", "t2", "t3"),
  Info_Format = c("year", "partial_series", "year"),
  Timeline_Start = c(1, 1, 2),
  Timeline_End = c(3, 4, 5),
  Timeline_Freq = c(1, 1, 2),
  `Imp/Exp` = "Imp",
  SACO_link = NA,
)
expand_trade_sources(trade_sources)
}
