test_that("WNBA League Standings V3", {
  skip_on_cran()
  skip_on_ci()
  
  x <- wnba_leaguestandingsv3(league_id = "10", season = most_recent_wnba_season() - 1)
  
  cols_x1 <- c(
    "LeagueID",
    "SeasonID",
    "TeamID",
    "TeamCity",
    "TeamName",
    "TeamSlug",
    "Conference",
    "ConferenceRecord",
    "PlayoffRank",
    "ClinchIndicator",
    "Division",
    "DivisionRecord",
    "DivisionRank",
    "WINS",
    "LOSSES",
    "WinPCT",
    "LeagueRank",
    "Record",
    "HOME",
    "ROAD",
    "L10",
    "Last10Home",
    "Last10Road",
    "OT",
    "ThreePTSOrLess",
    "TenPTSOrMore",
    "LongHomeStreak",
    "strLongHomeStreak",
    "LongRoadStreak",
    "strLongRoadStreak",
    "LongWinStreak",
    "LongLossStreak",
    "CurrentHomeStreak",
    "strCurrentHomeStreak",
    "CurrentRoadStreak",
    "strCurrentRoadStreak",
    "CurrentStreak",
    "strCurrentStreak",
    "ConferenceGamesBack",
    "DivisionGamesBack",
    "ClinchedConferenceTitle",
    "ClinchedDivisionTitle",
    "ClinchedPlayoffBirth",
    "ClinchedPlayIn",
    "EliminatedConference",
    "EliminatedDivision",
    "AheadAtHalf",
    "BehindAtHalf",
    "TiedAtHalf",
    "AheadAtThird",
    "BehindAtThird",
    "TiedAtThird",
    "Score100PTS",
    "OppScore100PTS",
    "OppOver500",
    "LeadInFGPCT",
    "LeadInReb",
    "FewerTurnovers",
    "PointsPG",
    "OppPointsPG",
    "DiffPointsPG",
    "vsEast",
    "vsAtlantic",
    "vsCentral",
    "vsSoutheast",
    "vsWest",
    "vsNorthwest",
    "vsPacific",
    "vsSouthwest",
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
    "Score_80_Plus",
    "Opp_Score_80_Plus",
    "Score_Below_80",
    "Opp_Score_Below_80",
    "TotalPoints",
    "OppTotalPoints",
    "DiffTotalPoints"
  )
  
  expect_in(sort(cols_x1), sort(colnames(x[[1]])))
  expect_s3_class(x[[1]], "data.frame")
  
  Sys.sleep(3)
  
})
