% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_home_button.R
\name{add_home_button}
\alias{add_home_button}
\title{Add home button to a web map}
\usage{
add_home_button(map, extent = NULL, position = "topleft")
}
\arguments{
\item{map}{'leaflet'.
Map widget object}

\item{extent}{'bbox', or 'numeric' vector of length four, with \code{xmin}, \code{xmax}, \code{ymin} and \code{ymax} values.
Extent object representing a rectangular geographical area on the map.
The extent must be specified in the coordinate reference system (CRS) of the web map,
usually in latitude and longitude using WGS 84 (also known as \href{https://epsg.io/4326}{EPSG:4326}).
By default, the extent will be automatically determined from
latitudes and longitudes of the map elements.}

\item{position}{'character' string.
Position of the button on the web map.
Possible values are "topleft", "topright", "bottomleft", and "bottomright".}
}
\value{
A new HTML web \code{map} with added element, an object of class 'leaflet'.
}
\description{
Add a button to a \href{https://leafletjs.com/}{Leaflet} map that zooms to the provided map extent.
}
\examples{
extent <- c(-124.409, -114.131, 32.534, 42.009) # California
make_map(maps = "Topo") |>
  add_home_button(extent = extent)
}
\seealso{
\code{\link{make_map}} function for creating a map widget.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
