% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_satellite_imagery.R
\name{get_satellite_imagery}
\alias{get_satellite_imagery}
\title{Get BOM Satellite Imagery}
\usage{
get_satellite_imagery(product_id, scans = 1, compat = "terra")
}
\arguments{
\item{product_id}{\code{Character}. \acronym{BOM} product \acronym{ID} to download
and import as a \CRANpkg{terra} \code{SpatRaster} S4 class (see
\verb{[terra::rast()]}) or \CRANpkg{stars} S3 \code{stars} class object.  A vector of
values from \code{\link[=get_available_imagery]{get_available_imagery()}} may be used here.  Value is required.}

\item{scans}{\code{Integer}. Number of scans to download, starting with most
recent and progressing backwards, \emph{e.g.}, 1 - the most recent single scan
available , 6 - the most recent hour available, 12 - the most recent 2
hours available, etc.  Negating will return the oldest files first.
Defaults to 1.  Value is optional.}

\item{compat}{\code{Character}. A string indicating the \R package with which the
returned imagery should be formatted for use, one of \code{terra} or
\code{stars}.  Defaults to \code{terra}.}
}
\value{
A \CRANpkg{terra} \code{SpatRaster} S4 class (see \verb{[terra::rast()]}) or
\CRANpkg{stars} S3 \code{stars} class object as selected by the user by
specifying \code{compat} of GeoTIFF images with layers named by \acronym{BOM}
product \acronym{ID}, timestamp and band.
}
\description{
Fetch \acronym{BOM} satellite GeoTIFF imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/gms/} and return a \CRANpkg{terra}
\code{SpatRaster} S4 class (see \verb{[terra::rast()]}) or \CRANpkg{stars} S3 \code{stars}
object of GeoTIFF files.  Files are available at ten minutes update
frequency with a 24-hour delete time.  It is suggested to check file
availability first by using \code{\link[=get_available_imagery]{get_available_imagery()}}.  Ported from
\CRANpkg{bomrang} with modifications.
}
\details{
Valid \acronym{BOM} satellite Product IDs for use with
\var{product_id} include:
\describe{
\item{IDE00420}{AHI cloud cover only 2km FD GEOS GIS}
\item{IDE00421}{AHI IR (Ch13) greyscale 2km FD GEOS GIS}
\item{IDE00422}{AHI VIS (Ch3) greyscale 2km FD GEOS GIS}
\item{IDE00423}{AHI IR (Ch13) Zehr 2km FD GEOS GIS}
\item{IDE00425}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km
FD GEOS GIS}
\item{IDE00426}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km
FD GEOS GIS}
\item{IDE00427}{AHI WV (Ch8) 2km FD GEOS GIS}
\item{IDE00430}{AHI cloud cover only 2km AUS equirect. GIS}
\item{IDE00431}{AHI IR (Ch13) greyscale 2km AUS equirect. GIS}
\item{IDE00432}{AHI VIS (Ch3) greyscale 2km AUS equirect. GIS}
\item{IDE00433}{AHI IR (Ch13) Zehr 2km AUS equirect. GIS}
\item{IDE00435}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km
AUS equirect. GIS}
\item{IDE00436}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km
AUS equirect. GIS}
\item{IDE00437}{AHI WV (Ch8) 2km AUS equirect. GIS}
\item{IDE00439}{AHI VIS (Ch3) greyscale 0.5km AUS equirect. GIS}
}
}
\note{
The original \CRANpkg{bomrang} version of this function supported local
file caching using \CRANpkg{hoardr}.  This version does not support this
functionality any longer due to issues with \acronym{CRAN} and
\CRANpkg{hoardr}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fetch AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km FD
# GEOS GIS {terra} `SpatRaster`` object for most recent single scan
 available

imagery <- get_satellite_imagery(product_id = "IDE00425", scans = 1)
plot(imagery)

# Get a list of available image files and use that to specify files for
# download, downloading the two most recent files available

avail <- get_available_imagery(product_id = "IDE00425")
imagery <- get_satellite_imagery(product_id = avail, scans = 2)
plot(imagery)
\dontshow{\}) # examplesIf}
}
\references{
Australian Bureau of Meteorology (\acronym{BOM}) high-definition satellite
images \cr \url{http://www.bom.gov.au/australia/satellite/index.shtml}.
}
\seealso{
\code{\link[=get_available_imagery]{get_available_imagery()}}

Other BOM: 
\code{\link{find_forecast_towns}()},
\code{\link{get_ag_bulletin}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{parse_ag_bulletin}()},
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
\concept{BOM}
\concept{data fetching}
