% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PortmanteauTest.R
\name{portmanteauTest}
\alias{portmanteauTest}
\title{Portmanteau tests}
\usage{
portmanteauTest(ar = NULL, ma = NULL, y, m = NULL)
}
\arguments{
\item{ar}{Vector of AR coefficients. If \code{NULL}, it is a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL}, it is an AR process.}

\item{y}{Univariate time series.}

\item{m}{Integer for the lag.}
}
\value{
A list of vectors of length \code{m}, corresponding to statistics and p-value for each lag, 
for standard, modified and self-normalized Ljung-Box and Box-Pierce methods.
}
\description{
Realizes portmanteau tests of the first m lags, this function uses \code{\link{portmanteauTest.h}}
for h in 1:m.
}
\examples{
 est<-estimation(p = 1, q = 1, y = CAC40return.sq)
 \donttest{portmanteauTest(ar = est$ar, ma = est$ma, y = CAC40return.sq, m = 20)}

}
\references{
Boubacar Maïnassara, Y. 2011, Multivariate portmanteau test for structural {VARMA} models
with uncorrelated but non-independent error terms \emph{Journal of Statistical Planning and Inference},
vol. 141, no. 8, pp. 2961-2975.

Boubacar Maïnassara, Y. and Saussereau, B. 2018, Diagnostic checking in multivariate {ARMA} models with 
dependent errors using normalized residual autocorrelations ,
 \emph{Journal of the American Statistical Association}, vol. 113, no. 524, pp. 1813-1827.

Francq, C., Roy, R. and Zakoïan, J.M. 2005, Diagnostic Checking in ARMA
 Models with Uncorrelated Errors, \emph{Journal of the American Statistical
 Association}, vol. 100, no. 470, pp. 532-544.
}
\seealso{
\code{\link{portmanteauTest.h}} to obtain statistics for only one h lag.
}
