% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_dictionary.R
\name{setup_dictionary}
\alias{setup_dictionary}
\title{Create a dictionary file for tidy data sets}
\usage{
setup_dictionary()
}
\value{
NULL. Error if raw data is not found or not in a package directory.
}
\description{
\code{setup_dictionary()} generates a dictionary CSV file in the
\verb{data/} directory. The dictionary file
contains information on the tidy data sets such as directory, file names, variable names,
variable types, and descriptions. If tidy data exists, the dictionary is populated with
relevant information; otherwise, it creates an empty dictionary CSV file.
}
\examples{
\dontshow{
temppkg <- tempdir()
devtools::create(temppkg, open=FALSE)
.old_wd <- setwd(temppkg)
}
\dontrun{
setup_rawdata()
# Go to data_processing.R, clean the raw data and export tidy data
setup_dictionary()
}
\dontshow{
setwd(.old_wd)
}

}
