% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_locator.R
\name{store_locator}
\alias{store_locator}
\title{Locale nearby Walmart stores}
\usage{
store_locator(key = auth_cache$KEY, lat = NULL, lon = NULL, city = NULL,
  zip = NULL, list_output = FALSE)
}
\arguments{
\item{key}{Your API access key.}

\item{lat}{latitude.}

\item{lon}{longitude.}

\item{city}{city.}

\item{zip}{zip code.}

\item{list_output}{Indicator for list output.}
}
\value{
A tibble with 12 columns in base response format.
}
\description{
\code{\link{store_locator}} helps locate nearest Walmart Stores by letting
you users search for stores by latitude and longitude, by zip code and by
city.
}
\details{
An API key will be required to run this function and can be acquired by
creating an account on the following website
\url{https://developer.walmartlabs.com/member}.

For more information refer to the original documentation
\url{https://developer.walmartlabs.com/docs/read/Store_Locator_API}.
}
\examples{
\dontrun{
key <- "************************"

store_locator(key = key, lat = 29, lon = -95)

store_locator(key = key, city = "Houston")

store_locator(key = key, zip = 77063)

store_locator(key = key, zip = 77063, list_output = TRUE)
}
}
