% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{searching}
\alias{searching}
\title{searching with text the Walmart catalogue}
\usage{
searching(query, key = auth_cache$KEY, lsPublisherId = NULL,
  categoryId = NULL, start = NULL, sort = NULL, order = NULL,
  numItems = NULL, facet = FALSE, facet.filter = NULL,
  list_output = FALSE)
}
\arguments{
\item{query}{Search text - whitespace separated sequence of keywords to
search for.}

\item{key}{Your API access key.}

\item{lsPublisherId}{Your LinkShare Publisher Id.}

\item{categoryId}{Category id of the category for search within a category.
This should match the id field from Taxonomy API.}

\item{start}{Starting point of the results within the matching set of
items - up to 10 items will be returned starting from this item.}

\item{sort}{Sorting criteria, allowed sort types are (relevance, price,
title, bestseller, customerRating, new). Default sort is by relevance.}

\item{order}{Sort ordering criteria, allowed values are (asc, desc).
This parameter is needed only for the sort types (price, title,
customerRating).}

\item{numItems}{Number of matching items to be returned, max value 25.
Default is 10.}

\item{facet}{Logical. Enables facets. Default value is FALSE.
Set this to on to enable facets.}

\item{facet.filter}{Filter on the facet attribute values. This parameter
can be set to <facet-name>:<facet-value> (without the angles). Here
facet-name and facet-value can be any valid facet picked from the search
API response when facets are on.}

\item{list_output}{Indicator for list output.}
}
\value{
A tibble with 15 columns in base response format.
}
\description{
\code{searching} allows text search on the Walmart.com catalogue and
returns matching items available for sale online.
An API key will be required to run this function and can be acquired by
creating an account on the following website
\url{https://developer.walmartlabs.com/member}.
}
\details{
For more information refer to the original documentation
\url{https://developer.walmartlabs.com/docs/read/Search_API}.

Response formats are described at the url
\url{https://developer.walmartlabs.com/docs/read/Item_Field_Description}.
}
\examples{
\dontrun{
key <- "************************"

searching(query = "ipod", key = key)

searching(query = "ipod", key = key, categoryId = 3944)

searching(query = "ipod", key = key, start = 44)

searching(query = "ipod", key = key, numItems = 44)

searching(query = "ipod", key = key, sort = "price", order = "asc")

searching(query = "ipod", key = key, sort = "bestseller")

searching(query = "ipod", key = key, list_output = TRUE)
}
}
