% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wactor-s3.R
\name{tfidf}
\alias{tfidf}
\title{Term frequency inverse document frequency}
\usage{
tfidf(object, .x = NULL)
}
\arguments{
\item{object}{Input object containing dictionary (column), e.g., wactor}

\item{.x}{Text from which the tfidf matrix will be created}
}
\value{
A c-style matrix
}
\description{
Converts character vector into a term frequency inverse document frequency
(TFIDF) matrix
}
\examples{

## create wactor
w <- wactor(letters)

## use wactor to create tfidf of same vector
tfidf(w, letters)

## using the initial data is the default; so you don't actually have to
## respecify it
tfidf(w)

## use wactor to create tfidf on new vector
tfidf(w, c("a", "e", "i", "o", "u"))

## apply directly to character vector
tfidf(letters)

}
