% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.activity.mastodon.R
\name{Create.activity.mastodon}
\alias{Create.activity.mastodon}
\title{Create mastodon activity network}
\usage{
\method{Create}{activity.mastodon}(
  datasource,
  type,
  subtype = NULL,
  ...,
  writeToFile = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"mastodon"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"activity"}.}

\item{subtype}{Character string. Subtype of activity network to be created. Can be set to \code{"tag"}. Default is
\code{NULL}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a mastodon activity network from collected posts. Nodes are posts and directed edges represent
the relationship of posts to one another.
}
\examples{
\dontrun{
# create a mastodon activity network
activity_net <- mastodon_data |> Create("activity")

# create a mastodon tag relations network
activity_net <- mastodon_data |> Create("activity", "tag")
}

}
