% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.listing.reddit.R, R/zzz.R
\name{Collect.listing.reddit}
\alias{Collect.listing.reddit}
\alias{collect_reddit_listings}
\title{Collect reddit thread listings from subreddits}
\usage{
\method{Collect}{listing.reddit}(
  credential,
  endpoint,
  subreddits,
  sort = "hot",
  period = "all",
  max = 25,
  waitTime = c(6, 8),
  ua = NULL,
  ...,
  writeToFile = FALSE,
  verbose = TRUE
)

collect_reddit_listings(
  subreddits,
  sort = "new",
  period = NULL,
  max = 25,
  waitTime = c(6, 8),
  ua = vsml_ua(),
  writeToFile = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{credential}{A \code{credential} object generated from \code{Authenticate} with class name \code{"reddit"}.}

\item{endpoint}{API endpoint.}

\item{subreddits}{Character vector. Subreddit names to collect thread listings from.}

\item{sort}{Character vector. Listing thread sort order. Options are \code{"hot"}, \code{"top"}, \code{"new"}, and
\code{"rising"}. Default is \code{"hot"}.}

\item{period}{Character vector. Listing top threads by time period. Only applicable to sort order by \code{"top"}.
Options are \code{"hour"}, \code{"day"}, \code{"week"}, \code{"month"}, \code{"year"} and \code{"all"}. Default is
\code{"all"}.}

\item{max}{Numeric vector. Maximum number of threads in listing to return. Default is \code{25}.}

\item{waitTime}{Numeric vector. Time range in seconds to select random wait from in-between url collection requests.
Minimum is 3 seconds. Default is \code{c(6, 8)} for a wait time chosen from between 6 and 8 seconds.}

\item{ua}{Character string. Override User-Agent string to use in Reddit thread requests. Default is \code{NULL}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write collected data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
A \code{tibble} object with class names \code{"listing"} and \code{"reddit"}.
}
\description{
Collects thread listings for one or more specified subreddits and structures the data into a dataframe.
}
\note{
The reddit endpoint used for collection has maximum limit of 25 per listing.
}
\examples{
\dontrun{
# subreddit url to collect threads from
subreddits  <- c("datascience")

redditListing <- redditAuth |>
  Collect(endpoint = "listing", subreddits = subreddits, sort = "new", writeToFile = TRUE)
}

}
