% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authenticate.youtube.R
\name{Authenticate.youtube}
\alias{Authenticate.youtube}
\title{YouTube API authentication}
\usage{
\method{Authenticate}{youtube}(socialmedia, apiKey, ..., verbose = TRUE)
}
\arguments{
\item{socialmedia}{Character string. Identifier for social media API to authenticate, set to \code{"youtube"}.}

\item{apiKey}{Character string. Google developer API key to authenticate.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
A \code{credential} object containing an api key \code{$auth} and social media type descriptor
\code{$socialmedia} set to \code{"youtube"}. Object has the class names \code{"credential"} and \code{"youtube"}.
}
\description{
YouTube authentication uses OAuth2 and requires a Google Developer API key as described here:
\url{https://developers.google.com/youtube/v3/docs/}.
}
\examples{
\dontrun{
# youtube authentication with google developer api key
myAPIKey <- "xxxxxxxxxxxx"

youtubeAuth <- Authenticate("youtube", apiKey = myAPIKey)
}

}
