% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddText.mastodon.R
\name{AddText.activity.mastodon}
\alias{AddText.activity.mastodon}
\title{Add columns containing text data to mastodon activity network dataframes}
\usage{
\method{AddText}{activity.mastodon}(net, data, ..., writeToFile = FALSE, verbose = TRUE)
}
\arguments{
\item{net}{A named list of dataframes \code{nodes} and \code{edges} generated by \code{Create}.}

\item{data}{A dataframe generated by \code{Collect}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges} including columns
containing text data.
}
\description{
Add columns containing text data to mastodon activity network dataframes
}
\examples{
\dontrun{
# add text to an activity network
net_activity <- collect_mdn |>
  Create("activity") |>
  AddText(collect_mdn)

# network
net_activity$nodes
net_activity$edges
}

}
