% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyzSample.R
\name{xyzSample}
\alias{xyzSample}
\title{Sampling from a \code{SpatRaster} vector using 3D coordinates}
\usage{
xyzSample(occs, envBrick, verbose = TRUE)
}
\arguments{
\item{occs}{A \code{data.frame} with at least three columns
named "longitude", "latitude", and "depth", or that
can be coerced into this format.}

\item{envBrick}{A \code{SpatRaster} vector object with
one environmental variable. Each layer represents
a depth slice. See Details for more information.}

\item{verbose}{\code{logical}. Switching to \code{FALSE} mutes message
describing which columns in \code{occs1} and \code{occs2} are interpreted
as x, y, and z coordinates.}
}
\value{
Vector of environmental values equal in length
to number of rows of input \code{occs} \code{data.frame}.
}
\description{
Gets values at x,y,z occurrences from a
given 3D environmental variable brick
}
\details{
The \code{SpatRaster} vector object should
have numeric names that correspond with the beginning
depth of a particular depth slice. For example, one
might have three layers, one from 0 to 10m, one from
10 to 30m, and one from 30 to 100m. You would name the
layers in this brick \verb{names(envBrick) <- c(0, 10, 30}.
\code{xyzSample} identifies the layer name that is closest
to the depth layer value at a particular X, Y
coordinate, and samples the environmental value at that
3D coordinate.
}
\examples{
library(terra)

# Create test raster
r1 <- rast(ncol=10, nrow=10)
values(r1) <- 1:100
r2 <- rast(ncol=10, nrow=10)
values(r2) <- c(rep(20, times = 50), rep(60, times = 50))
r3 <- rast(ncol=10, nrow=10)
values(r3) <- 8
envBrick <- c(r1, r2, r3)
names(envBrick) <- c(0, 10, 30)

# Create test occurrences
set.seed(0)
longitude <- sample(ext(envBrick)[1]:ext(envBrick)[2],
                    size = 10, replace = FALSE)
set.seed(0)
latitude <- sample(ext(envBrick)[3]:ext(envBrick)[4],
                   size = 10, replace = FALSE)
set.seed(0)
depth <- sample(0:35, size = 10, replace = TRUE)
occurrences <- as.data.frame(cbind(longitude,latitude,depth))

# Test function
occSample3d <- xyzSample(occurrences, envBrick)

# How to use
occurrences$envtValue <- occSample3d

}
\keyword{dataPrep}
