% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{testIntersection}
\alias{testIntersection}
\title{Test Intersection}
\usage{
testIntersection(a, b)
}
\arguments{
\item{a}{The first \code{SpatRaster} object}

\item{b}{The second \code{SpatRaster} object}
}
\value{
A logical vector stating whether the two
inputs overlap
}
\description{
Tests whether two rasters overlap. Used in
\verb{\code{\link[voluModel:diversityStack]{diversityStack}}}
function to verify all rasters in list overlap with the
template raster.
}
\examples{

library(terra)
rast1 <- rast(ncol=10, nrow=10)
values(rast1) <- rep(0:1, 50)

rast2 <- rast(ncol=10, nrow=10)
values(rast2) <- c(rep(0, 50), rep(1,50))

testIntersection(rast1, rast2)

rast1 <- crop(rast1, ext(10, 20, 30, 40))
rast2 <- crop(rast2, ext(-20, -10, -40, -30))

testIntersection(rast1, rast2)

}
\keyword{internal}
\keyword{plotting}
