% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputProcessingUtilties.R
\name{centerPointRasterTemplate}
\alias{centerPointRasterTemplate}
\title{Center Point Raster Template}
\usage{
centerPointRasterTemplate(rawPointData)
}
\arguments{
\item{rawPointData}{A \code{SpatVector} object with points
that will represent the center of each cell in the output
template.}
}
\value{
An empty \code{SpatRaster} designed to serve as a template for
rasterizing \code{SpatVector} objects.
}
\description{
Creates a \code{SpatRaster} template from a
\code{SpatVector} point object in which the raster cells
are centered on the vector points.
}
\details{
\code{rawPointData} is a \code{SpatVector} object that
contains x and y coordinates.
}
\examples{

library(terra)

# Create point grid
coords <- data.frame(x = rep(seq(1:5), times = 5),
                    y = unlist(lapply(1:5, FUN = function(x) {
                      rep(x, times = 5)})))

# Create data and add NAs to simulate uneven bottom depths
dd <- data.frame(SURFACE = 1:25,
                d5M = 6:30,
                d10M = 11:35,
                d25M = 16:40)
dd$d25M[c(1:5, 18:25)] <- NA
dd$d10M[c(3:5, 21:23)] <- NA
dd$d5M[c(4, 22)] <- NA

dd[,c("x","y")] <- coords

# Create SpatialPointsDataFrame
sp <- vect(dd, geom = c("x", "y"))

# Here's the function
template <- centerPointRasterTemplate(rawPointData = sp)
class(template)

}
\seealso{
\code{\link[terra:rasterize]{rasterize}}
}
\keyword{inputProcessing}
