% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoPlot.R
\name{volcanoPlot}
\alias{volcanoPlot}
\title{Create a volcano plot}
\usage{
volcanoPlot(data, highlights = c(), ...)
}
\arguments{
\item{data}{A data frame from getStats()}

\item{highlights}{A list providing a column and values to be highlighted in the chart}

\item{...}{Extra options to change the look of the plot. `fillcol =
c('sienna2', 'skyblue2', 'grey')`: fill colors; `pcutoff = 0.05`: p value
cutoff; `ecutoff = 1`: estimate cutoff, `GroupLabels = c('Comparison
Group', 'Reference Group')`: custom group labels.}
}
\value{
a volcano plot created with ggplot
}
\description{
Creates a paneled volcano plot showing the distribution of Adverse events. Options to highlight selected events and customize options are provided.
}
\examples{
settings<-list(
  stratification_col="AEBODSYS",
  group_col="ARM",
  reference_group="Placebo",
  comparison_group="Xanomeline High Dose",
  id_col="USUBJID"
)
stats<-getStats(dfAE=safetyData::adam_adae, dfDemog = safetyData::adam_adsl, settings)
volcanoPlot(stats)

}
