% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_vint.R
\name{vivi_interaction}
\alias{vivi_interaction}
\title{vivi_interaction}
\usage{
vivi_interaction(
  data,
  fit,
  response,
  nmax = 500,
  gridSize = 50,
  predictFun = NULL,
  normalized = FALSE,
  vars = NULL,
  reorder = TRUE
)
}
\arguments{
\item{data}{Data frame used for \code{fit}.}

\item{fit}{A supervised ML model understood by \code{condvis2::CVpredict} (or supply \code{predictFun}).}

\item{response}{Name of the response column in \code{data}.}

\item{nmax}{Maximum number of rows to consider for grids. Default 500. Use all rows if \code{NULL}.}

\item{gridSize}{Grid size for evaluating partial dependence. Default 50.}

\item{predictFun}{Optional prediction function \verb{(fit, data, prob = TRUE/FALSE)}.
If \code{NULL}, an internal CVpredict-based function is used.}

\item{normalized}{Should H be normalised. Default FALSE.}

\item{vars}{Optional character vector of feature names to restrict the calculation.}

\item{reorder}{If TRUE, reorder the resulting matrix with \code{vividReorder()}. Default TRUE.}
}
\value{
Square interaction matrix with zero diagonal.
}
\description{
Compute pairwise interactions only (Friedman's H), without importance.
}
\examples{
# Example 1 — interactions with a linear model
aq <- na.omit(airquality)
fit_lm <- lm(Ozone ~ ., data = aq)
int_mat <- vivi_interaction(data = aq, fit = fit_lm, response = "Ozone")
dim(int_mat); int_mat[1:3, 1:3]
# viviHeatmap(int_mat)  # if you want to visualise interactions only

# Example 2 — classification with ranger
\donttest{
if (requireNamespace("ranger", quietly = TRUE)) {
  library(ranger)
  fit_rf <- ranger(Species ~ ., data = iris,
                   importance = "impurity", probability = TRUE)
  vivi_interaction(data = iris, fit = fit_rf, response = "Species")
}
}

}
