% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally_it.R
\name{tally_it}
\alias{tally_it}
\title{tally_it}
\usage{
tally_it(df, groupit, new_colname)
}
\arguments{
\item{df}{A rearranged vcf dataframe (arrange_data)}

\item{groupit}{A vector containing column names that data should be grouped by}

\item{new_colname}{The name of the count column}
}
\value{
A dataframe with columns from the 'groupit' vector and the number of times each unique grouping occurs in the data
}
\description{
Groups the input vcf data frame using a list of variables and tallies the number of occurrences
}
\examples{
# Sample dataframe of 7 variants across 2 samples
df <- data.frame(
  sample = c( "sample1", "sample1", "sample1", "sample2",
              "sample2", "sample2", "sample2"),
  CHROM = c("PB1", "PB2", "PB2", "LEO", "LEO", "LEO", "ALE"),
  SegmentSize = c(2280, 2274, 2274, 1701, 1701, 1701, 1888 ),
  minorfreq = c(0.04422785, 0.03738175, 0.01390202, 0.02927786,
                0.03071955, 0.02626025, 0.02875321)
)

# Example 1: to get the sum of variants on every segment:
groupit = c('sample','CHROM', "SegmentSize")
tally_it(df, groupit, "snv_count")

# Example 2: to get the count across genomes:
groupit = c('sample')
tally_it(df, groupit, "snv_count")

}
