% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-visreg.R
\name{plot.visreg}
\alias{plot.visreg}
\title{Visualization of regression functions}
\usage{
\method{plot}{visreg}(
  x,
  overlay = FALSE,
  print.cond = FALSE,
  whitespace = 0.2,
  partial = identical(x$meta$trans, I),
  band = TRUE,
  rug = ifelse(partial, 0, 2),
  strip.names = is.numeric(x$fit[, x$meta$by]),
  legend = TRUE,
  top = c("line", "points"),
  gg = FALSE,
  line.par = NULL,
  fill.par = NULL,
  points.par = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{visreg} or \code{visregList} object; see \code{\link[=visreg]{visreg()}}.}

\item{overlay}{By default, when \code{by} is specified, separate panels are used
to display each cross-section. If \code{overlay=TRUE}, these cross-sections are
overlaid on top of each other in a single plot.}

\item{print.cond}{If \code{print.cond=TRUE}, the explanatory variable values
conditioned on in a conditional plot are printed to the console
(default: \code{FALSE}). If \code{print.cond=TRUE} and \code{type="contrast"}, the
conditions will still be printed, but they have no bearing on the plot
unless interactions are present.}

\item{whitespace}{When \code{xvar} is a factor, \code{whitespace} determines the
amount of space in between factors on the x-axis.  Default is 0.2, meaning
that 20 percent of the horizontal axis is whitespace.}

\item{partial}{If \code{partial=TRUE} (the default), partial residuals are
shown on the plot.}

\item{band}{If \code{band=TRUE} (the default), confidence bands are shown on
the plot.}

\item{rug}{By default, partial residuals are plotted. Alternatively, a
\code{\link[=rug]{rug()}} may be plotted along the horizontal axis instead.  Setting \code{rug=TRUE}
turns off partial residuals by default; if one wants both to be plotted, both
\code{rug=TRUE} and \code{partial=TRUE} need to be specified. Two types of rug plots
are available. If \code{rug=1} or \code{rug=TRUE}, then a basic rug is drawn on the
bottom. If \code{rug=2}, then separate rugs are drawn on the top for
observations with positive residuals and on the bottom for observations with
negative residuals. Such plots are particularly useful in logistic regression
(see examples).}

\item{strip.names}{When \code{by=TRUE}, \code{strip.names=TRUE} adds the
name of the \code{by} variable to the strip at the top of each panel. Default is
\code{FALSE} for factors and \code{TRUE} for numeric \code{by} variables.  \code{strip.names} can
also be a character vector, in which case it replaces the strip names
altogether with values chosen by the user.}

\item{legend}{For overlay plots, (\code{overlay=TRUE}), should visreg create a
legend? If \code{legend=TRUE} (the default), a legend is placed in the top margin.}

\item{top}{By default, the fitted line is plotted on top of the partial
residuals; usually this is preferable, but it does run the risk of obscuring
certain residuals. To change this behavior and plot the partial residuals on
top, specify \code{top='points'}.}

\item{gg}{By default (\code{gg=FALSE}), \code{visreg} will use the \strong{lattice} package
to render the plot if multiple panels are required. If \code{gg=TRUE}, it will
use the \strong{ggplot2} package instead, provided that it is installed.}

\item{line.par}{List of parameters (see \code{\link[=par]{par()}}) to pass to \code{lines(...)} or
\code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} when lines are plotted.}

\item{fill.par}{List of parameters (see \code{\link[=par]{par()}}) to pass to \code{polygon(...)} or
\code{\link[ggplot2:geom_polygon]{ggplot2::geom_polygon()}} when shaded confidence regions are plotted.}

\item{points.par}{List of parameters (\code{\link[=par]{par()}}) to pass to \code{points(...)} or
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} when partial residuals are plotted.}

\item{...}{Graphical parameters can be passed to the function to customize
the plots. If \code{by=TRUE}, lattice parameters can be passed, such as \code{layout}
(see examples below).}
}
\description{
A function for visualizing regression models quickly and easily. Default
plots contain a confidence band, prediction line, and partial residuals.
Factors, transformations, conditioning, interactions, and a variety of other
options are supported.  The \code{plot.visreg()} function accepts a \code{visreg}
or \code{visregList} object as calculated by \code{\link[=visreg]{visreg()}} and creates the plot.
}
\examples{
fit <- lm(Ozone ~ Solar.R + Wind + Temp,data=airquality)
visreg(fit, "Wind", line=list(col="red"), points=list(cex=1, pch=1))

## Changing appearance
visreg(fit, "Wind", line=list(col="red"), points=list(cex=1, pch=1))

## See ?visreg and https://pbreheny.github.io/visreg for more examples
}
\references{
Breheny P and Burchett W. (2017) Visualization of regression models using
visreg. \emph{R Journal}, \strong{9}: 56-71.
\doi{10.32614/RJ-2017-046}
}
\seealso{
\url{https://pbreheny.github.io/visreg/articles/options.html}, \code{\link[=visreg]{visreg()}},
\code{\link[=visreg2d]{visreg2d()}}
}
\author{
Patrick Breheny and Woodrow Burchett
}
