test_that("guess_element correctly identifies individual elements", {
  expect_equal(guess_type(TRUE), "logical")
  expect_equal(guess_type(T), "logical")
  expect_equal(guess_type("TRUE"), "logical")
  expect_equal(guess_type("T"), "logical")
  expect_equal(guess_type("10"), "integer")
  expect_equal(guess_type(10), "integer")
  expect_equal(guess_type("10.1"), "double")
  expect_equal(guess_type(10.1), "double")
  expect_equal(guess_type("abc"), "character")
  expect_equal(guess_type("$%TG"), "character")
  expect_equal(guess_type(NA), NA_character_)
})
test_that("guess_element correctly identifies individual list elements", {
  expect_equal(guess_type(list(TRUE)), "logical")
  expect_equal(guess_type(list(T)), "logical")
  expect_equal(guess_type(list("TRUE")), "logical")
  expect_equal(guess_type(list("T")), "logical")
  expect_equal(guess_type(list("10")), "integer")
  expect_equal(guess_type(list(10)), "integer")
  expect_equal(guess_type(list("10.1")), "double")
  expect_equal(guess_type(list(10.1)), "double")
  expect_equal(guess_type(list("abc")), "character")
  expect_equal(guess_type(list("$%TG")), "character")
  expect_equal(guess_type(list(NA)), NA_character_)
})
