% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visTree.R
\name{visTree}
\alias{visTree}
\title{Visualization of subgroups for decision trees}
\usage{
visTree(cond.tree, rng = NULL, interval = FALSE, color.type = 1,
  alpha = 0.5, add.h.axis = TRUE, add.p.axis = TRUE,
  text.round = 1, text.main = 1.5, text.bar = 1.5,
  text.title = 1.5, text.label = 1.5, text.axis = 1.5,
  text.percentile = 0.7, density.line = TRUE)
}
\arguments{
\item{cond.tree}{Decision tree generated as a party object.}

\item{rng}{Restrict plotting to a particular set of nodes. Default value is set as NULL.}

\item{interval}{logical. Continuous outcome (interval = FALSE) and Categorical outcome (interval = TRUE).}

\item{color.type}{Color palettes (rainbow_hcl = 1; heat_hcl = 2; terrain_hcl = 3; sequential_hcl = 4 ; diverge_hcl = 5)}

\item{alpha}{Transparency for horizontal colored bars in each subplot. Values between 0 to 1.}

\item{add.h.axis}{logical. Add axis for the outcome distribution (add.h.axis = TRUE), remove axis for the outcome (add.h.axis = FALSE).}

\item{add.p.axis}{logical. Add axis for the percentiles (add.p.axis = TRUE) computed over covariate values, remove axis for the percentiles (add.p.axis = FALSE).}

\item{text.round}{Round the threshold displayed on the horizontal bar}

\item{text.main}{Change the size of the main titles}

\item{text.bar}{Change the size of the text in the horizontal bar}

\item{text.title}{Change the size of the text in the title}

\item{text.label}{Change the size of the axis annotation}

\item{text.axis}{Change the size of the text of axis labels}

\item{text.percentile}{Change the size of the percentile title}

\item{density.line}{logical. Draw a density line. (density.line = TRUE).}
}
\description{
This visualization characterizes subgroups defined by a decision tree structure and identifies the range of covariate values associated with outcome values in each subgroup.
}
\examples{
data(blsdata)
newblsdata<-blsdata[,c(7,21, 22,23, 24, 25, 26)]
## Continuous response
ptree1<-partykit::ctree(kcal24h0~., data = newblsdata)
visTree(ptree1, text.axis = 1.3, text.label = 1.2, text.bar = 1.2, alpha = 0.5)

## Repeated covariates in the splits of the decision tree
ptree2<-partykit::ctree(kcal24h0~skcal+rrvfood+resteating+age, data = blsdata)
visTree(ptree2, text.axis = 1.3, text.label = 1.2, text.bar = 1.2, alpha = 0.5)

## Categorical response
blsdataedit<-blsdata[,-7]
blsdataedit$bin<-0 
blsdataedit$bin<-cut(blsdata$kcal24h0, unique(quantile(blsdata$kcal24h0)), 
include.lowest = TRUE, dig.lab = 4)
names(blsdataedit)[26]<-"kcal24h0"
ptree3<-partykit::ctree(kcal24h0~hunger+rrvfood+resteating+liking, data = blsdataedit)
visTree(ptree3, interval = TRUE,  color.type = 1, alpha = 0.6, 
text.percentile = 1.2, text.bar = 1.8)

## Other decision trees (e.g., rpart) 
ptree4<-rpart::rpart(kcal24h0~wanting+liking+rrvfood, data = newblsdata, 
control = rpart::rpart.control(cp = 0.029))
visTree(ptree4, text.bar = 1.8, text.label = 1.4, text.round = 1, 
density.line = TRUE, text.percentile = 1.3)

## Change the color scheme and transparency of the horizontal bars
ptree1<-partykit::ctree(kcal24h0~., data = newblsdata)
visTree(ptree1, text.axis = 1.3, text.label = 1.2, text.bar = 1.2, alpha = 0.65, 
color.type = 3)

## Remove the axes corresponding to the percentiles and the response values.
ptree1<-partykit::ctree(kcal24h0~., data = newblsdata)
visTree(ptree1, text.axis = 1.3, text.label = 1.2, text.bar = 1.2, alpha = 0.65, 
color.type = 3, add.p.axis = FALSE, add.h.axis = FALSE) 

# Remove the density line over the histograms 
ptree1<-partykit::ctree(kcal24h0~., data = newblsdata)
visTree(ptree1, text.axis = 1.3, text.label = 1.2, text.bar = 1.2, alpha = 0.65, 
color.type = 3, density.line = FALSE) 
}
\author{
Ashwini Venkatasubramaniam and Julian Wolfson
}
\keyword{decision}
\keyword{pathway}
\keyword{tree}
\keyword{visualization}
