% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streamline_and_field3d.R
\name{streamline_and_field3d}
\alias{streamline_and_field3d}
\title{Vector field and streamline in 3D (single combined figure)}
\usage{
streamline_and_field3d(
  field,
  H1,
  H2,
  G1,
  G2,
  a,
  b,
  NX = 8,
  NY = 6,
  NZ = 6,
  p,
  t_final,
  step,
  arrows = c("both", "line", "cone", "none"),
  arrow_scale = 0.08,
  normalize_bias = 1,
  normal_color = "rgba(0,0,0,0.55)",
  normal_width = 2,
  arrow_color = "#1d3557",
  arrow_opacity = 0.95,
  arrow_size = 0.35,
  traj_color = "#e63946",
  traj_width = 5,
  traj_markers = TRUE,
  traj_marker_size = 2,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white"),
  ...
)
}
\arguments{
\item{field}{A function representing the vector field. It can be given as
\code{function(x, y, z)} or \code{function(x, y, z, t)}, and must
return a numeric vector of length three \code{c(Fx, Fy, Fz)}.}

\item{H1, H2}{Functions of one variable \code{x} giving the lower and
upper bounds in the \code{y} direction.}

\item{G1, G2}{Functions of two variables \code{x} and \code{y} giving
the lower and upper bounds in the \code{z} direction.}

\item{a, b}{Numeric endpoints of the interval for \code{x}. It is
assumed that \code{b > a}.}

\item{NX, NY, NZ}{Integers greater than or equal to one specifying the
sampling density of the field in the three parameter directions.}

\item{p}{Numeric vector of length three giving the initial point of
the streamline, in the form \code{c(x0, y0, z0)}.}

\item{t_final}{Final integration time for the streamline. A negative value
integrates backward in time.}

\item{step}{Step size for the fixed-step RK4 integration. Must be
strictly positive.}

\item{arrows}{Character string indicating the arrow mode. Allowed
values are \code{"none"}, \code{"line"}, \code{"cone"} and
\code{"both"}.}

\item{arrow_scale}{Global arrow length scale, expressed as a fraction
of the largest span of the bounding box.}

\item{normalize_bias}{Numeric saturation bias used in the scaling of
the vector norm. Larger values make arrow lengths saturate earlier.}

\item{normal_color}{Color of the arrow shafts (line segments).}

\item{normal_width}{Numeric width of the arrow shafts.}

\item{arrow_color}{Color of the arrow heads (cones or chevrons).}

\item{arrow_opacity}{Opacity of the arrow heads.}

\item{arrow_size}{Relative size of the arrow heads with respect to
\code{arrow_scale}.}

\item{traj_color}{Color of the streamline.}

\item{traj_width}{Width of the streamline.}

\item{traj_markers}{Logical; if \code{TRUE}, draws markers along the
streamline.}

\item{traj_marker_size}{Size of the markers drawn on the streamline.}

\item{scene}{List with 3D scene settings for \pkg{plotly}, such as
aspect mode and axis titles.}

\item{bg}{List with background colors for the figure, typically with
entries \code{paper} and \code{plot}.}

\item{...}{Reserved for backward compatibility. Do not use.}
}
\value{
A list with:
\itemize{
\item \code{field_points}: a data frame with base positions
\code{x, y, z} and the magnitude of the field at each point,
\item \code{field_segments}: a data frame with columns
\code{x0, y0, z0, x1, y1, z1} describing the arrow shafts,
\item \code{traj}: a data frame with the streamline data, including
time, coordinates and local speed,
\item \code{fig}: a \pkg{plotly} object containing the combined
field and streamline visualization.
}
}
\description{
Draws a three-dimensional vector field inside a curvilinear volume and
overlays a streamline that follows the field, all in a single
\pkg{plotly} figure. The streamline is obtained by integrating an
ordinary differential equation using a fixed-step Runge-Kutta method
of order four (RK4), starting from an initial point.
}
\details{
The volume is defined by:
\itemize{
\item an interval for \code{x} between \code{a} and \code{b},
\item lower and upper functions for \code{y} that depend on \code{x},
\item lower and upper functions for \code{z} that may depend on
both \code{x} and \code{y}.
}

The function builds a regular grid in three parameters and maps each
grid point to the physical coordinates \code{(x, y, z)} using linear
blends between the corresponding bounds. The vector field is then
evaluated at each of these points to obtain the base positions and
vectors used to draw the arrows.

Arrow lengths are scaled using a saturated version of the vector norm.
This means that small magnitudes produce short arrows, whereas very
large magnitudes are limited by a bias parameter so that they do not
dominate the entire plot. A global scale factor controls the typical
arrow length relative to the size of the domain.

The streamline is defined as the trajectory of a particle whose
velocity at each point is given by the vector field evaluated along
the path. The field may optionally depend on time; if the function
\code{field} has a time argument, it is used during integration. The
integration runs from time zero up to a final time, with positive or
negative direction depending on the sign of the final time.

The resulting figure combines:
\itemize{
\item a set of arrows representing the vector field,
\item a space curve representing the streamline,
\item optional markers along the streamline and highlighted start
and end points.
}
}
\examples{
\donttest{
H1 <- function(x) -1
H2 <- function(x)  1
G1 <- function(x, y) -0.5
G2 <- function(x, y)  0.5
field <- function(x, y, z) c(-y, x, 0.6)

out <- streamline_and_field3d(
  field, H1, H2, G1, G2,
  a = -2, b = 2, NX = 10, NY = 8, NZ = 5,
  p = c(1, 0, 0), t_final = 2, step = 0.05,
  arrows = "both", arrow_scale = 0.12, normalize_bias = 1,
  normal_color = "rgba(0,0,0,0.55)", normal_width = 2,
  arrow_color  = "#1d3557", arrow_opacity = 0.95, arrow_size = 0.4,
  traj_color   = "#e63946", traj_width = 5, traj_markers = TRUE
)
}

}
