% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.agree}
\alias{se.agree}
\title{Computes the estimate and standard error for a G-index of agreement}
\usage{
se.agree(f, n, k, m)
}
\arguments{
\item{f}{number of objects rated in agreement}

\item{n}{sample size (number of objects)}

\item{k}{number of rating categories}

\item{m}{number of studies in planned meta-analysis}
}
\value{
Returns a one-row matrix:
\itemize{
\item MLE - maximum likelihood estimate of G-index
\item Estimate - adjusted estimate of G-index
\item SE - standard error of adjusted estimate
}
}
\description{
Computes an adjusted G-index of agreement for two raters using the number
of objects rated in agreement, the sample size (number of objects), and
the number of rating categories. The adjustment for the G-index and its
standard error is optimized for the the number of planned studies in the
meta-analysis. The G-index and standard error output from this function
can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions.
The G-index is usually preferred to Cohen's kappa.
}
\examples{
se.agree(42, 50, 3, 4)

# Should return: 
#             MLE  Estimate         SE
# G-index:   0.76      0.75 0.06391375 


}
\references{
\insertRef{Bonett2022}{vcmeta}
}
