% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_read_csv.R
\name{vs_read_csv}
\alias{vs_read_csv}
\title{Reading a CSV file}
\usage{
vs_read_csv(vsc, path)
}
\arguments{
\item{vsc}{A variantspark connection.}

\item{path}{The file's path.}
}
\value{
spark_jobj, shell_jobj
}
\description{
The \code{vs_read_csv()} reads a CSV file format and returns a \code{jobj}
object from \code{CsvFeatureSource} scala class.
}
\examples{
 
\dontrun{
library(sparklyr)

sc <- spark_connect(master = "local")
vsc <- vs_context(sc)

hipster_labels <- vs_read_csv(vsc, 
                              system.file("extdata/hipster_labels.txt",
                                          package = "variantspark"))

hipster_labels 
}

}
