% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_models.R
\name{panel_granger_test}
\alias{panel_granger_test}
\title{Panel Granger Causality Test (Dumitrescu-Hurlin)}
\usage{
panel_granger_test(panel_data, lags = c(1L, 2L))
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{lags}{Integer vector of lag orders to test. Default c(1, 2).}
}
\value{
A data frame with test results for each direction and lag.
}
\description{
Performs panel Granger causality tests between direct and production prices.
}
\details{
Tests both directions: direct -> production and production -> direct.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2019, 5),
    sector = rep(LETTERS[1:5], each = 20),
    log_direct = rnorm(100, 5, 0.5),
    log_production = rnorm(100, 5, 0.5)
  )

  granger_results <- panel_granger_test(panel)
  print(granger_results)
}
}

}
