% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pos_check.R
\name{write_pos_check}
\alias{write_pos_check}
\alias{suggest_pos_check}
\title{Suggest a range check}
\usage{
write_pos_check(d, vars = names(d), only_positive = TRUE, file = stdout())

suggest_pos_check(d, vars = names(d), only_positive = TRUE)
}
\arguments{
\item{d}{\code{data.frame}, used to generate the checks}

\item{vars}{\code{character} optionally the subset of variables to be used.}

\item{only_positive}{if \code{TRUE} only numerical values for positive values are included}

\item{file}{file to which the checks will be written to.}
}
\value{
\code{suggest_pos_check} returns \code{\link[validate:validator]{validate::validator()}} object with the suggested rules.
\code{write_pos_check} write the rules to file and returns invisibly a named list of checks for each variable.
}
\description{
Suggest a range check
}
\examples{
data(SBS2000, package="validate")

suggest_range_check(SBS2000)

# checks the ranges of each variable
suggest_range_check(SBS2000[-1], min=TRUE, max=TRUE)

# checks the ranges of each variable
suggest_range_check(SBS2000, vars=c("turnover", "other.rev"), min=FALSE, max=TRUE)
}
