% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_group.R
\name{get_group}
\alias{get_group}
\title{Get series-group observations}
\usage{
get_group(name = NULL, ...)
}
\arguments{
\item{name}{A \code{character} of length 1 indicating the series group to
retrieve.}

\item{...}{Additional query parameters. Possible values are \code{start_date}
and/or \code{end_date} (both character), or one of \code{recent},
\code{recent_weeks}, \code{recent_months}, or \code{recent_years} (all
numeric).}
}
\value{
A \code{tibble}.
}
\description{
\code{get_group} returns observations from a Bank of Canada series group.
}
\details{
Valet, the server-side API, does not always return observations
  filtered by \strong{...} arguments for series groups, even if it will accept
  the request.
}
\examples{
get_group("BAPF_TRANSACTION_DATA")
get_group("gbpp")

\dontrun{
#this is a series
get_group("FXCADAUD")
}

}
