% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot_decorator.R
\name{g_forest_with_transform}
\alias{g_forest_with_transform}
\title{Create a forest plot from an \code{rtable} with x transform settings}
\usage{
g_forest_with_transform(
  tbl,
  col_x = attr(tbl, "col_x"),
  col_ci = attr(tbl, "col_ci"),
  vline = 1,
  forest_header = attr(tbl, "forest_header"),
  xlim = c(0.1, 10),
  transform_x = NA,
  x_at = c(0.1, 1, 10),
  width_columns = NULL,
  lbl_col_padding = 0,
  rel_width_forest = 0.25,
  font_size = 12,
  col_symbol_size = attr(tbl, "col_symbol_size"),
  col = getOption("ggplot2.discrete.colour")[1],
  ggtheme = NULL,
  as_list = FALSE
)
}
\arguments{
\item{tbl}{(\code{VTableTree})\cr \code{rtables} table with at least one column with a single value and one column with 2
values.}

\item{col_x}{(\code{integer(1)} or \code{NULL})\cr column index with estimator. By default tries to get this from
\code{tbl} attribute \code{col_x}, otherwise needs to be manually specified. If \code{NULL}, points will be excluded
from forest plot.}

\item{col_ci}{(\code{integer(1)} or \code{NULL})\cr column index with confidence intervals. By default tries to get this from
\code{tbl} attribute \code{col_ci}, otherwise needs to be manually specified. If \code{NULL}, lines will be excluded
from forest plot.}

\item{vline}{(\code{numeric})\cr position of the vertical reference line on the plot. like 0 and 1 in forest plot.}

\item{forest_header}{(\code{character(2)})\cr text displayed to the left and right of \code{vline}, respectively.
If \code{vline = NULL} then \code{forest_header} is not printed. By default tries to get this from \code{tbl} attribute
\code{forest_header}. If \code{NULL}, defaults will be extracted from the table if possible, and set to
\code{"Comparison\\nBetter"} and \code{"Treatment\\nBetter"} if not.}

\item{xlim}{(\code{numeric})\cr range of x-axis limits. Example: \code{c(0.1, 10)}}

\item{transform_x}{(\code{character})\cr function for x-values transformation}

\item{x_at}{(\code{numeric})\cr specifies the tick marks on the axis.
The value of \code{union(xlim, vline)} or Example: \code{c(0.1,1,10)}.}

\item{width_columns}{(\code{numeric})\cr a vector of column widths. Each element's position in
\code{colwidths} corresponds to the column of \code{tbl} in the same position. If \code{NULL}, column widths are calculated
according to maximum number of characters per column.}

\item{lbl_col_padding}{(\code{numeric})\cr padding between label and columns value. Default is \code{0}.}

\item{rel_width_forest}{(\code{proportion})\cr proportion of total width to allocate to the forest plot. Relative
width of table is then \code{1 - rel_width_forest}. If \code{as_list = TRUE}, this parameter is ignored.}

\item{font_size}{(\code{numeric(1)})\cr font size.}

\item{col_symbol_size}{(\code{numeric} or \code{NULL})\cr column index from \code{tbl} containing data to be used
to determine relative size for estimator plot symbol. Typically, the symbol size is proportional
to the sample size used to calculate the estimator. If \code{NULL}, the same symbol size is used for all subgroups.
By default tries to get this from \code{tbl} attribute \code{col_symbol_size}, otherwise needs to be manually specified.}

\item{col}{(\code{character})\cr color(s).}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to control styling of the plot.}

\item{as_list}{(\code{flag})\cr whether the two \code{ggplot} objects should be returned as a list. If \code{TRUE}, a named list
with two elements, \code{table} and \code{plot}, will be returned. If \code{FALSE} (default) the table and forest plot are
printed side-by-side via \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}.}
}
\value{
\code{ggplot} forest plot and table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Given a \code{\link[rtables:rtable]{rtables::rtable()}} object with at least one column with a single value and one column with 2
values, converts table to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object and generates an accompanying forest plot. The
table and forest plot are printed side-by-side.
}
