% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{county_tbl_df}
\alias{county_tbl_df}
\title{United States Counties}
\format{
A tibble with 3,142 observations and 15 variables:
\describe{
  \item{name}{Name of the county.}
  \item{state}{State in which the county is located (factor with 51 levels).}
  \item{pop2000}{Population of the county in the year 2000.}
  \item{pop2010}{Population of the county in the year 2010.}
  \item{pop2017}{Population of the county in the year 2017.}
  \item{pop_change}{Change in population over the years.}
  \item{poverty}{Poverty rate in the county.}
  \item{homeownership}{Rate of homeownership in the county.}
  \item{multi_unit}{Percentage of multi-unit housing.}
  \item{unemployment_rate}{Unemployment rate in the county.}
  \item{metro}{Indicates if the county is in a metropolitan area (factor with 2 levels).}
  \item{median_edu}{Median education level in the county (factor with 4 levels).}
  \item{per_capita_income}{Per capita income in the county.}
  \item{median_hh_income}{Median household income in the county.}
  \item{smoking_ban}{Indicates if there is a smoking ban in place (factor with 3 levels).}
}
}
\source{
United States Census Bureau
}
\usage{
data(county_tbl_df)
}
\description{
The dataset name has been changed to 'county_tbl_df' to avoid confusion with other packages
in the R ecosystem from which datasets have been sourced. This naming convention helps
distinguish this dataset as part of the 'usdatasets' package and assists users in identifying
its specific characteristics. The suffix 'tbl_df' identifies the dataset as a tibble. The original content of the dataset has not been modified in any way.
}
