% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UChicago.R
\docType{data}
\name{uchicago_1}
\alias{uchicago_1}
\title{Primary colors of the University of Chicago, USA}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on \href{https://www.uchicago.edu}{UChicago}'s 
\href{https://creative.uchicago.edu/brand-resources/}{Brand Identity Guidelines}.
}
\usage{
uchicago_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uchicago_1} provides the four primary colors
of the \href{https://www.uchicago.edu}{University of Chicago}, USA.
}
\details{
The 4 primary colors are 
\code{"maroon"} (defined as Pantone 202C, CMYK 0/100/70/50 RGB 128/0/0, or HEX #800000),
\code{"light greystone"} (defined as Pantone Cool Gray 3C, CMYK 4/3/5/16, RGB 217/217/217, or HEX #D9D9D9),
\code{"greystone"} (defined as Pantone Warm Gray 7C, CMYK 16/23/23/44, RGB 166/166/166, or HEX #A6A6), and
\code{"dark greystone"} (defined as Pantone Warm Gray 11C, CMYK 26/30/34/62, RGB 115/115/115, or HEX #73737).

\code{uchicago_1} uses the HEX color definitions.


The primary color palette should be used in all digital and print communications to assure brand consistency. 
Within the primary palette itself, \code{"maroon"} should always be the dominant color, with Greys used as accents.

For specific color ratios and layout examples, see the 
\href{https://creative.uchicago.edu/brand-resources/}{Brand Identity Guidelines}. 

Always use these colors at 100 percent. Tints should never be used.
}
\examples{
uchicago_1
unikn::seecol(uchicago_1, main = "Primary colors Chicago Uni") # view color palette

}
\seealso{
\code{\link{uchicago_2}} for secondary, accent colors of University of Chicago;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
