% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trinity_College_Dublin.R
\docType{data}
\name{trinity_2}
\alias{trinity_2}
\title{Secondary colours of Trinity College Dublin, Ireland}
\format{
An object of class \code{character} of length 55.
}
\source{
Color definitions are based on \href{https://www.tcd.ie}{TCD}'s 
\href{https://www.tcd.ie/identity/colour-palette/}{visual identity guidelines}.
}
\usage{
trinity_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{trinity_2} provides the secondary colour palette  
of \href{https://www.tcd.ie}{Trinity College Dublin}, Ireland.
}
\details{
\code{trinity_2} uses the HEX color definitions.


The secondary colour palette supports the primary colours of \code{\link{trinity_1}}. 

It is used for graphic elements within communications 
(e.g., in illustrations, charts, diagrams and iconography). 
It can also be used to add colour to items where a photographic image is unsuitable or unavailable 
(e.g., posters, slides or backdrops). 

It is important to remember that these are supporting colours only; 
they should not predominate or overwhelm the 
primary blue, grey, and white colours (of \code{\link{trinity_1}}).
}
\examples{
trinity_2
main_cols <- seq(1, 51, by = 5)
unikn::seecol(trinity_2[main_cols], 
              main = "Main secondary colours of the Trinity College Dublin")  # view palette

}
\seealso{
\code{\link{trinity_1}} for primary colors of Trinity College Dublin; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{ucc_1}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2023-09-05.
}
\concept{Irish university color palettes}
\keyword{datasets}
