% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{generateVCF}
\alias{generateVCF}
\title{Generate VCF file from UMI sample or UMI experiment object}
\usage{
generateVCF(object, outDir = getwd(), outFile, printAll = FALSE)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object}

\item{outDir}{String. Output directory, defaults to working directory.}

\item{outFile}{String. Name of the output file}

\item{printAll}{Logical. Should all or only trusted variant be printed?}
}
\value{
A VCF file
}
\description{
Generate VCF file from UMI sample or UMI experiment object
}
\examples{
\dontrun{
library(umiAnalyzer)

main <- system.file("extdata", package = "umiAnalyzer")

simsen <- createUmiExperiment(main)

simsen <- filterUmiObject(simsen)

generateVCF(simsen,'simsen.vcf', printAll = FALSE, save = FALSE)
}

}
