% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_station_measurements}
\alias{plot_station_measurements}
\title{Descriptive plot of daily time series data}
\usage{
plot_station_measurements(
  env_data,
  variables,
  years = NULL,
  smoothing_factor = 1
)
}
\arguments{
\item{env_data}{A data table of measurements of one air quality measurement station.
The data should contain the following columns:
\describe{
\item{Station}{Station identifier where the data was collected.}
\item{Komponente}{The environmental component being measured
(e.g., temperature, NO2).}
\item{Wert}{The measured value of the component.}
\item{date}{The timestamp for the observation,
formatted as a Date-Time object in the format
\code{"YYYY-MM-DD HH:MM:SS"} (e.g., "2010-01-01 07:00:00").}
\item{Komponente_txt}{A textual description or label for the component.}
}}

\item{variables}{list of variables to plot. Must be in \code{env_data$Komponente}.
Meteorological variables can be obtained from params.yaml.}

\item{years}{Optional. A numeric vector, list, or a range specifying the
years to restrict the plotted data.
You can provide:
\itemize{
\item A single year: \code{years = 2020}
\item A numeric vector of years: \code{years = c(2019, 2020, 2021)}
\item A range of years: \code{years = 2019:2021}
If not provided, data for all available years will be used.
}}

\item{smoothing_factor}{A number that defines the magnitude of smoothing.
Default is 1. Smaller numbers correspond to less smoothing, larger numbers to more.}
}
\value{
A \code{ggplot} object. This object contains:
\itemize{
\item A time-series line plot for each variable in \code{variables}.
\item Smoothed lines, with smoothing defined by \code{smoothing_factor}.
}
}
\description{
This function produces descriptive time-series plots with smoothing
for the meteorological and potential target variables that were measured at a station.
}
\examples{
library(data.table)
env_data <- data.table(
  Station = "Station_1",
  Komponente = rep(c("TMP", "NO2"), length.out = 100),
  Wert = rnorm(100, mean = 20, sd = 5),
  date = rep(seq.POSIXt(as.POSIXct("2022-01-01"), , "hour", 50), each = 2),
  year = 2022,
  Komponente_txt = rep(c("Temperature", "NO2"), length.out = 100)
)
plot <- plot_station_measurements(env_data, variables = c("TMP", "NO2"))

}
