% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt.R
\name{tt_widths}
\alias{tt_widths}
\title{Set proportional column widths}
\usage{
tt_widths(table, ...)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{...}{Width values as numbers. Can be unnamed (applied in order) or
named by column. Values represent relative proportions.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Sets column widths as proportions that fill the page or container width.
Widths are converted to Typst \code{fr} (fractional) units.
}
\details{
Widths are relative proportions, not absolute values. For example,
\code{tt_widths(tbl, 1, 2, 1)} creates columns at 25\%, 50\%, 25\% of the container width.
}
\examples{
# Equal widths
tt(mtcars[1:5, 1:3], rownames = FALSE) |> tt_widths(1, 1, 1)

# Proportional widths (25\%, 50\%, 25\%)
tt(mtcars[1:5, 1:3], rownames = FALSE) |> tt_widths(1, 2, 1)

# Named columns
tt(mtcars[1:5, 1:3], rownames = FALSE) |> tt_widths(mpg = 1, cyl = 2, disp = 1)

}
