## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#",
  warning = FALSE,
  message = FALSE
)

## ---- echo=FALSE--------------------------------------------------------------
tmp <- rbind(c("A","B"), c("C", "D"))

rownames(tmp) <- c("**EXPOSURE +**","**EXPOSURE -**")
names(tmp) <- NULL

knitr::kable(tmp,
             col.names = c("OUTCOME +","OUTCOME -"),
               row.names = TRUE)

## ----setup, echo = TRUE-------------------------------------------------------
library(twoxtwo)
library(dplyr)

## -----------------------------------------------------------------------------
sh <-
  tibble(
    smoke = c(rep(TRUE, 100), rep(FALSE,200)),
    hbp = c(rep(1,40),rep(0,60),rep(1,50),rep(0,150))
    )

## -----------------------------------------------------------------------------
sh

## -----------------------------------------------------------------------------
sh_2x2 <-
  sh %>%
  twoxtwo(., exposure = smoke, outcome = hbp)

## -----------------------------------------------------------------------------
sh_2x2

## -----------------------------------------------------------------------------
sh_2x2$tbl

## -----------------------------------------------------------------------------
sh_2x2$cells

## -----------------------------------------------------------------------------
sh_2x2$exposure

## -----------------------------------------------------------------------------
sh_2x2$outcome

## -----------------------------------------------------------------------------
sh_2x2$n_missing

## -----------------------------------------------------------------------------
sh_2x2$data

## -----------------------------------------------------------------------------
sh_2x2 %>% 
  summary(.)

## -----------------------------------------------------------------------------
sh_2x2_sum <-
  sh_2x2 %>% 
  summary(.)

## -----------------------------------------------------------------------------
sh_2x2_sum

## -----------------------------------------------------------------------------
do.call("rbind", sh_2x2_sum)

## -----------------------------------------------------------------------------
sh_2x2 %>%
  odds_ratio()

## -----------------------------------------------------------------------------
sh_2x2 %>%
  risk_ratio()

## -----------------------------------------------------------------------------
sh_2x2 %>%
  risk_diff()

## -----------------------------------------------------------------------------
sh %>%
  odds_ratio(., exposure = smoke, outcome = hbp, alpha = 0.05)

## -----------------------------------------------------------------------------
sh %>%
  risk_ratio(., exposure = smoke, outcome = hbp, alpha = 0.05)

## -----------------------------------------------------------------------------
sh %>%
  risk_diff(., exposure = smoke, outcome = hbp, alpha = 0.05)

## -----------------------------------------------------------------------------
sh_2x2 %>%
  fisher()

## -----------------------------------------------------------------------------
sh_2x2 %>%
  chisq()

## -----------------------------------------------------------------------------
sh %>%
  fisher(., exposure = smoke, outcome = hbp)

## -----------------------------------------------------------------------------
sh %>%
  chisq(., exposure = smoke, outcome = hbp)

## -----------------------------------------------------------------------------
sh %>%
  twoxtwo(., 
          exposure = smoke, 
          outcome = hbp, 
          levels = list(exposure = c(FALSE,TRUE), outcome = c(1,0)))

## -----------------------------------------------------------------------------
sh %>%
  odds_ratio(., 
             exposure = smoke, 
             outcome = hbp, 
             levels = list(exposure = c(FALSE,TRUE), outcome = c(1,0)))

