% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpexp.R
\name{tpexp}
\alias{tpexp}
\alias{dtpexp}
\alias{ptpexp}
\alias{qtpexp}
\alias{rtpexp}
\title{The two-parameter exponential distribution(tpexp)}
\usage{
dtpexp(x, theta = 0, beta = 1, log = FALSE)

ptpexp(q, theta = 0, beta = 1, lower.tail = TRUE, log.p = FALSE)

qtpexp(p, theta = 0, beta = 1, lower.tail = TRUE, log.p = FALSE)

rtpexp(n, theta = 0, beta = 1)
}
\arguments{
\item{x, q}{vector of quantile.}

\item{theta}{location parameter, where \eqn{\theta > 0}.}

\item{beta}{scale parameter, where \eqn{\beta > 0} and \eqn{rate=1/\beta}.}

\item{log, log.p}{logical; (default = \code{FALSE}), if \code{TRUE}, then probabilities are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dtpexp} gives the density,
\code{ptpexp} gives the distribution function,
\code{qtpexp} gives the quantile function,
and \code{rtpexp} generates random samples.
}
\description{
Density, distribution function, quantile function, and random generation function
for the two-parameter exponential distribution with \code{theta} and \code{beta}
}
\examples{

x <- c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0)
dtpexp(x,theta=0,beta=1)
dtpexp(x,theta=0,beta=1,log=TRUE)

q <- c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0)
ptpexp(q,theta = 0, beta = 1)
ptpexp(q,theta=0, beta = 1, lower.tail = FALSE)

q <- c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0)
p<- ptpexp(q,theta = 0, beta = 1); p
qtpexp(p,theta=0, beta = 1)

rtpexp(5, theta=0, beta=1)
rtpexp(10, theta=1, beta=1.5)

}
