% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_repres.R
\name{rank_repres}
\alias{rank_repres}
\title{Ensemble representativeness ranking}
\usage{
rank_repres(data, method = "all", ensemble = "median")
}
\arguments{
\item{data}{data.table with three variables: dataset, date, value}

\item{method}{character with seven options: mean, var (variance), slope, kge (Kling–Gupta Efficiency), tss (Taylor Skill Score), kld (Kullback–Leibler Divergence), all (default)}

\item{ensemble}{character with two options: mean, median (default)}
}
\value{
data.table 2-column (dataset, repres_metric) or 8-column (dataset, mean, variance, ...) in case of method = all
}
\description{
The function \code{rank_repres} ranks the elements of a dataset ensemble in terms of a representativeness metric.
}
\details{
data is a data.table (time, value) method relates to the metric used to estimate the similarity to the ensemble mean/median. Can be mean, variance, correlation, slope, Kling–Gupta efficiency, Taylor skill score, Kullback–Leibler divergence, and all (for returning all of them)
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
download_data("gpcc", tempdir(), timestep = "yearly")
download_data("ghcn", tempdir(), timestep = "yearly")
r1 <- raster::brick(paste0(tempdir(),
"/gldas-vic-v2-0_tp_mm_land_194801_201412_025_yearly.nc"))
s1 <- fldmean(r1)
s1$dataset <- "gldas-vic"
r2 <- raster::brick(paste0(tempdir(),
"/gpcc-v2022_tp_mm_land_198201_202012_025_yearly.nc"))
s2 <- fldmean(r2)
s2$dataset <- "gpcc"
r3 <- raster::brick(paste0(tempdir(),
"/ghcn-v2_tp_mm_land_190001_201505_025_yearly.nc"))
s3 <- fldmean(r2)
s3$dataset <- "ghcn"
dt <- rbind(r1, r2, r3)
dr <- rank_repres(dt[year(date) >= 1991 & year(date) <= 2012, .(dataset, date, value)])
}
}
