% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvYearAnnuityCompSemiAnnually.R
\name{pvYearlyAnnuityCompSemiAnnually}
\alias{pvYearlyAnnuityCompSemiAnnually}
\title{Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Semi-Annually.}
\usage{
pvYearlyAnnuityCompSemiAnnually(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}
}
\description{
Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Semi-Annually.
}
\details{
As \insertCite{humm;textual}{tvmComp} explains, while dealing with annuity scenarios, first we must identify whether the problem is that of an Ordinary Annuity or Annuity Due. In an Ordinary Annuity the payment is made at the end of the payment period, whereas, in Annuity Due payment is made in the beginning of the year.
To incorporate this effect, the method \code{pvYearlyAnnuityCompSemiAnnually()} is developed to compute Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is compounded Semi-Annually. This method gives Present Value when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years,\code{pmt} is amount of one annuity and \code{bgn} is the mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments).
}
\examples{
pvYearlyAnnuityCompSemiAnnually(0.11,4,-300,0)
pvYearlyAnnuityCompSemiAnnually(0.11,4,-300,1)
pvYearlyAnnuityCompSemiAnnually(0.11,4,300,0)
pvYearlyAnnuityCompSemiAnnually(0.11,4,300,1)
}
\references{
\insertRef{humm}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
