% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvQuarterPaidAnnuityCompQuarterly.R
\name{pvQuarterlyPaidAnnuityCompQuarterly}
\alias{pvQuarterlyPaidAnnuityCompQuarterly}
\title{Computing Present Value of Quarterly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.}
\usage{
pvQuarterlyPaidAnnuityCompQuarterly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}.
}
\description{
Computing Present Value of Quarterly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.
}
\details{
As explained by \insertCite{brook;textual}{tvmComp}, the way it is possible to find the Present Value of a single cash flow , on the same lines the Present Value of an annuity stream can also be computed.
The method \code{pvQuarterlyPaidAnnuityCompQuarterly()} is developed to compute Present Value of Quarterly-Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.The method gives Present Value when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years, \code{pmt} is amount of one annuity and \code{bgn} is the computational mode (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments)
}
\examples{
pvQuarterlyPaidAnnuityCompQuarterly(0.06,12, -200, 1)
pvQuarterlyPaidAnnuityCompQuarterly(0.06,12, -200, 0)
pvQuarterlyPaidAnnuityCompQuarterly(0.06,12, 200, 1)
pvQuarterlyPaidAnnuityCompQuarterly(0.06,12, 200, 0)
}
\references{
\insertRef{brook}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
