% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_principal_eff.R
\name{surv.principal.eff}
\alias{surv.principal.eff}
\title{Fit CIFs using principal stratum strategy for competing risks data, based on efficient influence functions}
\usage{
surv.principal.eff(A, Time, cstatus, X = NULL)
}
\arguments{
\item{A}{Treatment indicator, 1 for treatment and 0 for control.}

\item{Time}{Time to event.}

\item{cstatus}{Indicator of event, 1 for the primary event, 2 for the intercurrent event, 0 for censoring.}

\item{X}{Baseline covariates.}
}
\value{
A list including
\describe{
\item{time1}{Time points in the treated group.}
\item{time0}{Time points in the control group.}
\item{cif1}{Estimated cumulative incidence function in the treated group.}
\item{cif0}{Estimated cumulative incidence function in the control group.}
\item{se1}{Standard error of the estimated cumulative incidence function in the treated group.}
\item{se0}{Standard error of the estimated cumulative incidence function in the control group.}
\item{time}{Time points in both groups.}
\item{ate}{Estimated treatment effect (difference in cumulative incidence functions).}
\item{se}{Standard error of the estimated treatment effect.}
\item{p.val}{P value of testing the treatment effect based on the efficient influence function of
the restricted mean survival time lost by the end of study.}
\item{coef}{Coefficients of covariates in the working Cox models for each event.}
\item{ph}{P values of the proportional hazards assumption in the working Cox models for each event.}
\item{cumhaz}{Baseline cumulative hazards in the working Cox models.}
}
}
\description{
This function estimates the potential cumulative incidence function
based on efficient influence functions using principal stratum strategy (competing
risks data structure). Cox models are employed for survival models. The estimand is defined in a subpopulation where
intercurrent events would never occur regardless of treatment conditions.
}
\details{
\describe{
The principal stratum strategy aims to stratify the population into subpopulations based on the joint
potential occurrences of intercurrent events under the two treatment assignments \eqn{(R(1), R(0))}.
Suppose we are interested in a principal stratum comprised of individuals who would never experience
intercurrent events, regardless of which treatment they receive. This principal stratum can be indicated
by \eqn{\{R(1)=R(0)=\infty\}}. The treatment effect is now defined within this subpopulation,
\eqn{\tau(t) = P(T(1) < t \mid R(1)=R(0)=\infty) - P(T(0) < t \mid R(1)=R(0)=\infty),}
representing the difference in probabilities of experiencing primary outcome events during \eqn{(0,t)}
under active treatment and placebo in the subpopulation that will not experience intercurrent events
regardless of treatment during \eqn{(0,t)}. A principal ignorability assumption is made for identification.
If the size of the target principal stratum is small, the results could be highly variable.
}
}
\seealso{
\code{\link[tteICE]{surv.principal}}, \code{\link[tteICE]{surv.tteICE}}
}
\keyword{internal}
