% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\name{abc}
\alias{abc}
\alias{plot.abc}
\title{ABC analysis}
\usage{
abc(x, prc = c(0.2, 0.3, 0.5))

\method{plot}{abc}(x, cex.prc = 0.8, ...)
}
\arguments{
\item{x}{this can either be an array, where each column is a series, or a vector of values. If \code{x} is an array of time series, then the importance of each series is calculated as the mean of the observations (sales volume). Otherwise, value can be whatever quantity is provided.}

\item{prc}{a vector of percentages indicating how many items are included in each class. By default this is \code{c(0.2,0.3,0.5)}, but any set of percentage values can be used as long as \code{0<=prc[i]<=1} and \code{sum(prc)==1}.}

\item{cex.prc}{font size of percentages reported in plot.}

\item{...}{additional arguments passed to the plot.}
}
\value{
Return object of class \code{abc} and contains:
\itemize{
\item \code{value}: a vector containing the importance value of each series.
\item \code{class}: a vector containing the class membership of each series.
\item \code{rank}: a vector containing the rank of each series, with 1 being the highest ranking series.
\item \code{conc}: the importance concentration of each class, as percentage of total value.
}
}
\description{
Perform ABC analysis on a set of time series.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(abc)}: plot ABC or XYZ analyses.

}}
\examples{
x <- abs(matrix(cumsum(rnorm(5400,0,1)),36,150))
z <- abc(x)
print(z)
plot(z)

}
\references{
Ord K., Fildes R., Kourentzes N. (2017) \href{https://kourentzes.com/forecasting/2017/10/16/new-forecasting-book-principles-of-business-forecasting-2e/}{Principles of Business Forecasting, 2e}. \emph{Wessex Press Publishing Co.}, p.515-518.
}
\seealso{
\code{\link{xyz}}, \code{\link{abcxyz}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
