% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_hp.R
\name{ts_fil_hp}
\alias{ts_fil_hp}
\title{Hodrick-Prescott Filter}
\usage{
ts_fil_hp(lambda = 100, preserve = 0.9)
}
\arguments{
\item{lambda}{It is the smoothing parameter of the Hodrick-Prescott filter.
Lambda = 100*(frequency)^2
Correspondence between frequency and lambda values
annual => frequency = 1 // lambda = 100
quarterly => frequency = 4 // lambda = 1600
monthly => frequency = 12 // lambda = 14400
weekly => frequency = 52 // lambda = 270400
daily (7 days a week) => frequency = 365 // lambda = 13322500
daily (5 days a week) => frequency = 252 // lambda = 6812100}

\item{preserve}{value between 0 and 1. Balance the composition of observations and applied filter.
Values close to 1 preserve original values. Values close to 0 adopts HP filter values.}
}
\value{
A \code{ts_fil_hp} object.
}
\description{
Decompose a series into trend and cyclical components using the
Hodrick–Prescott (HP) filter and optionally blend with the original series.

This filter removes short-term fluctuations by penalizing changes in the
growth rate of the trend component.
}
\details{
The filter strength is governed by \code{lambda = 100 * frequency^2}.
Use \code{preserve} in (0, 1] to convex-combine the raw series and the HP trend.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_hp(lambda = 100*(26)^2)  #frequency assumed to be 26
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
\references{
\itemize{
\item R. J. Hodrick and E. C. Prescott (1997). Postwar U.S. business cycles:
An empirical investigation. Journal of Money, Credit and Banking, 29(1).
}
}
