% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dataleaks.R
\name{find_dataleaks}
\alias{find_dataleaks}
\title{Correlation calculation based on rolling window with overlapping observations.}
\usage{
find_dataleaks(lstx, h, cutoff = 1)
}
\arguments{
\item{lstx}{list of time series}

\item{h}{length of forecast horizon}

\item{cutoff}{benchmark value for corr absolute value, default 1}
}
\value{
list of matching quantities
}
\description{
Correlation calculation based on rolling window with overlapping observations.
}
\examples{
a = rnorm(15)
lst <- list(
 a = a,
 b = c(a[10:15], rnorm(10), a[1:5], a[1:5]),
 c = c(rnorm(10), a[1:5])
)
find_dataleaks(lst, h=5)
#' a = rnorm(15)
lst <- list(
 x= a,
 y= c(rnorm(10), a[1:5])
)

find_dataleaks(lst, h=5)

# List without naming elements
lst <- list(
 a,
 c(rnorm(10), a[1:5], a[1:5]),
 rnorm(10)
)
find_dataleaks(lst, h=5)
}
