% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dupes.R
\name{find_dupes}
\alias{find_dupes}
\title{Identify duplicate cases}
\usage{
find_dupes(data, ...)
}
\arguments{
\item{data}{A data frame or tibble}

\item{...}{Variable names to check for duplicates}
}
\value{
The original data frame or tibble with an additional logical column 'has_dupes'
which is `TRUE` for rows that have duplicates based on the specified variables and `FALSE` otherwise.
}
\description{
Identify duplicate cases in a data frame or tibble based on specific variables.
A logical column `has_dupes` is added, that indicates whether or not a row has duplicate values based on the provided variables.
}
\examples{
# Example data
print(sailor_students)

# Find duplicate cases based on 'sgic', 'school' and 'class'
sailor_students_dupes <- find_dupes(sailor_students, sgic, school, class)

# Rows where 'has_dupes' is `TRUE` indicate duplicates based on the provided columns
print(sailor_students_dupes)
}
