#'STLS objective function
#'
#'
#'@param bet parameter values. Column matrix with p rows.
#'@param x model matrix
#'@param y response variable, column matrix
#'
#'@return
#'Returns the value of the objective function for given parameter values
#' 
#'@export
#'@author Anita Lindmark and Maria Karlsson
#'@seealso \code{\link{stls}}
#'
funcval.STLS <- function(bet,x,y) 		
{
  funcvalue <- sum((y-pmax((1/2)*y, x%*%bet))^2)
  return(funcvalue)
}
