% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrawlCorrelationFunctions.R
\name{acf_LM}
\alias{acf_LM}
\title{Autocorrelation function of the long memory trawl function}
\usage{
acf_LM(x, alpha, H)
}
\arguments{
\item{x}{The argument (lag) at which the autocorrelation function associated
with the long memory trawl function will be evaluated}

\item{alpha}{parameter in the long memory trawl}

\item{H}{parameter in the long memory trawl}
}
\value{
The autocorrelation function of the long memory trawl function
 evaluated at x
}
\description{
This function computes the autocorrelation function associated with the long
memory trawl function.
}
\details{
The trawl function is parametrised by the two parameters \eqn{H> 1}
 and \eqn{\alpha > 0} as follows: \deqn{g(x) = (1-x/\alpha)^{-H},  \mbox{ for
 }  x \le 0.} Its autocorrelation function is given by
 \deqn{r(x)=(1+x/\alpha)^{(1-H)}, \mbox{ for } x \ge 0.}
}
\examples{
acf_LM(1,0.3,1.5)
}
