% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrawlCorrelationFunctions.R
\name{acf_Exp}
\alias{acf_Exp}
\title{Autocorrelation function of the exponential trawl function}
\usage{
acf_Exp(x, lambda)
}
\arguments{
\item{x}{The argument (lag) at which the autocorrelation function associated
with the exponential trawl function will be evaluated}

\item{lambda}{parameter in the exponential trawl}
}
\value{
The autocorrelation function of the exponential trawl function
 evaluated at x
}
\description{
This function computes the autocorrelation function associated with the
exponential trawl function.
}
\details{
The trawl function is parametrised by the parameter \eqn{\lambda > 0}
 as follows:
\deqn{g(x) = e^{\lambda x},  \mbox{ for } x \le 0.}
Its autocorrelation function is given by:
\deqn{r(x) = e^{-\lambda x},  \mbox{ for } x \ge 0.}
}
\examples{
acf_Exp(1,0.1)
}
