% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nankivell_walser.R
\name{walser}
\alias{walser}
\title{eGFR using the Walser formula}
\usage{
walser(SCr, Age, Weight, Sex, Units = "SI")
}
\arguments{
\item{SCr}{numeric vector of serum creatinine in µmol/l (or mg/dl if units = "US")}

\item{Age}{numeric vector of patient ages in years}

\item{Weight}{numeric vector of patient weights in kilograms}

\item{Sex}{character vector of sex ("F" for female, "M" for male)}

\item{Units}{non-vectorised optional parameter for creatinine units ("SI" for µmol/l (default), "US" for mg/dl)}
}
\value{
numeric vectors of eGFR values
}
\description{
A vectorised function to calculate eGFR using the Walser formula. By default the equation accepts
serum creatinine in µmol/l but can be changed to mg/dl by setting the units parameter to "US".
It has not been possible to run automated tests to confirm the
accuracy of this function, so please use with caution.
}
\details{
Reference: Walser M, Drew HH, Guldan JL. Prediction of glomerular filtration rate in advanced
chronic renal failure. Kidney International 1993; 44:2245-1148.
}
\examples{
walser(SCr = 118, Age = 74, Weight = 65, Sex = "M") # 56.1
}
